<!DOCTYPE html>
<html lang="az">
<head>
{headers}
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1">
	<meta name="format-detection" content="telephone=no">
	<link rel="stylesheet" type="text/css" href="style.css">
	<link rel="icon" href="img/favicon.png" type="image/png" sizes="16x16">
	<link rel="icon" href="img/favicon.ico" type="image/ico" sizes="16x16">
	<link rel="mask-icon" href="img/favicon.svg" color="#FFE000">
	<link rel="shortcut icon" type="image/x-icon" href="img/favicon.ico">

	<meta name="description" content="Onlayn təklif etdiyiniz xidmətlərə nəzarət üçün etibarlı tərəfdaş.">
	<meta name="format-detection" content="telephone=no">
	<meta property="og:type" content="website">
	<meta property="og:url" content="https://hostarex.com/">
	<meta property="og:title" content="Hostarex - təhlükəsiz və etibarlı hosting provayderi">
	<meta property="og:description" content="Sizin üçün ən sürətli hostinq paketləri təqdim edir və xidmət göstərməkdən zövq alırıq. 7/24 Texniki dəstək xəttimiz açıqdır.">
	<meta property="og:image" content="https://hostarex.com/img/blog/c.webp" alt="Hostarex - təhlükəsiz və etibarlı hosting provayderi">
	<meta property="twitter:card" content="summary_large_image">
	<meta property="twitter:url" content="https://hostarex.com/">
	<meta property="twitter:title" content="Hostarex - təhlükəsiz və etibarlı hosting provayderi">
	<meta property="twitter:description" content="Sizin üçün ən sürətli hostinq paketləri təqdim edir və xidmət göstərməkdən zövq alırıq. 7/24 Texniki dəstək xəttimiz açıqdır.">
	<meta property="twitter:image" content="http://hostarex.com/img/blog/c.webp" alt="Hostarex - təhlükəsiz və etibarlı hosting provayderi">
    
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" integrity="sha512-iBBXm8fW90+nuLcSKlbmrPcLa0OT92xO1BIsZ+ywDWZCvqsWgccV3gFoRBv0z+8dLJgyAHIhR35VZc2oM/gI1w==" crossorigin="anonymous" />
	<link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.css">
	<link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">

	<script src="https://unpkg.com/swiper/swiper-bundle.js"></script>
	<script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>	
</head>
<body>
	<div class="container">
		<a id="button"><i class="fas fa-arrow-up"></i></a>
		<div class="banner">
            <div class="banner-left"></div>
			<div class="banner-content">
				<div>
                    <p>Hostarex serverləri artıq Azərbaycanda!</p>
				</div>
				<div>
					<a class="more-info" href="hosting">Ətraflı məlumat</a>
				</div>
			</div>
            <div class="banner-right"></div>
		</div>
		             [not-aviable=showfull|feedback|static] <div class="main-page">   [/not-aviable]
			<header>
				<div class="header-content">
					<div class="logo">
						<a href="/"><img src="img/logo-bold.svg" alt="hostarex logo" id="logo"></a>
					</div>
					<nav class="mobile-menu">
						<div id="burger">
					        <div class="bar topBar"></div>
					        <div class="bar btmBar"></div>
					    </div>
					    <ul class="web-ul">
							<li class="btn inactive"><a href="hosting">Hostinq</a></li>
							<li class="btn inactive"><a href="domain">Domen</a></li>
							<li class="btn inactive"><a href="ssl">SSL</a></li>
                            <li class="btn inactive"><a href="blog">Bloq</a></li>
							<li class="btn inactive"><a href="https://hostarex.com/billing/sign-up">Qeydiyyat</a></li>
							<li class="btn inactive"><a href="https://hostarex.com/billing/sign-in"><i class="far fa-user hostaex-signin"></i></a></li>
						</ul>

						<ul class="mobile-ul">
							<li><a href="hosting">Hostinq</a></li>
							<li><a href="domain">Domen</a></li>
							<li><a href="ssl">SSL</a></li>
							<li><a href="sayt-qur">Sayt qur</a></li>
							<li><a href="blog">Bloq</a></li>
							<li><a href="https://hostarex.com/billing/">Daxil ol</a></li>
							<li class="social-icons">
								<ul class="social">
									<li><a href="https://www.facebook.com/hostarexcom"><i class="fab fa-facebook-messenger"></i></a></li>
									<li><a href="https://www.linkedin.com/company/hostarexcom/"><i class="fab fa-linkedin-in"></i></a></li>
									<li><a href="https://www.instagram.com/hostarexcom/"><i class="fab fa-instagram"></i></a></li>
									<li><a href="https://t.me/hostarexcom"><i class="fab fa-telegram-plane"></i></a></li>
								</ul>
							</li>
							<li>
                               <p class="mail">hello@hostarex.com</p>
							</li>
						</ul>
					</nav>	
				</div>
			</header>
             [aviable=main]  
			<section class="hostarex-main">
                <div class="hm-content">
                    <div class="head-text">
                        <h1>İstifadəçilərinizə xidmətlərinizi<br>onlayn təklif edin.</h1>
                        <p>Daha çox istifadəçiyə çatmaq üçün sürətli və etibarlı tərəfdaş.</p>
                        <div class="cta-buttons mobile-cta">
                            <a class="cta-button" href="hosting">Təkliflərlə tanış ol</a>
                        </div>
                    </div>
                    <div class="head-image">
                        <img src="img/server.webp" alt="Baku Creative Projects"/>
                    </div>              
                </div>
			</section>   
			<section class="hostarex-hostinq">	
				<div class="mobile-banner">
					<p>Hostarex'ə xoş gəldiniz!</p>
					<a class="more-info" href="hosting">xidmət paketləri</a>
				</div>			
				<div class="hostinq-header">
					<h1>Azərbaycanda bir hostinq seç </h1>
					<p class="subheader">Sizin üçün etibarlı, istifadəçiləriniz üçün çox sürətli paketlər.</p>
				</div>
				<div class="host-container">
					<div class="host-wrapper">
						<div class="host-slide">
							<h1>X Paketi</h1>
							<a href="hosting" class="price">114&#8380; / illik</a>
							<p>1 veb sat üçün uyğun paket</p>
							<ul>
								<li><i class="fas fa-circle"></i> 1 Domen</li>
								<li><i class="fas fa-circle"></i> 20GB Disk yaddaşı</li>
								<li><i class="fas fa-circle"></i> 5 E-poçt hesabı</li>
                   
							</ul>
							<div><a href="hosting">Ətraflı məlumat</a><i class="fas fa-long-arrow-alt-right"></i></div>
						</div>
						<div class="host-slide">
							<h1>X2 Paketi</h1>
							<a href="hosting" class="price">360&#8380; / illik</a>
							<p>Veb saytlarınız üçün limitsiz xidmətlərimizdən istifadə edin</p>
							<ul>
								<li><i class="fas fa-circle"></i> 2 Domen</li>
								<li><i class="fas fa-circle"></i> 50GB Disk yaddaşı</li>
								<li><i class="fas fa-circle"></i> 15 E-poçt hesabı</li>
                        
							</ul>
							<div><a href="hosting">Ətraflı məlumat</a><i class="fas fa-long-arrow-alt-right"></i></div>
						</div>
						<div class="host-slide">
							<h1>X3 Paketi</h1>
							<a href="hosting" class="price">650&#8380; / illik</a>
							<p>Daha çox güc, limitsiz imkanlar və sürətli veb saytlar!</p>
							<ul>
								<li><i class="fas fa-circle"></i> 10 Domen</li>
								<li><i class="fas fa-circle"></i> 100GB Disk yaddaşı</li>
								<li><i class="fas fa-circle"></i> Limitsiz E-poçt hesabı</li>
                                 <li><i class="fas fa-circle"></i> Azərbaycan lokasiyalı</li>
							</ul>
							<div><a href="hosting">Ətraflı məlumat</a><i class="fas fa-long-arrow-alt-right"></i></div>
						</div>
					</div>
				</div>
			</section>
			<section class="more-hosting">
				<div>
					<h1>Hostarex sizə daha nə təklif edir?</h1>
					<a class="cta-button" href="hosting">ətraflı məlumat</a>
				</div>
			</section>
        	<div class="com-svg"></div>
			<section class="hostarex-web">
				<div class="web-content">
					<div>
						<div class="logo-mini">
							<a href="#"><img src="img/logo-web-light.svg" alt="hostarex logo"></a>
						</div>
						<p>Sayt hazırlamaq anlayışı indiyə qədər bu sahə ilə əlaqəsi olmayan insanlara çox çətin gəlib. Bizim hazırladığımız platformada əsas məqsəd, şirkət rəhbərləri, fərdi şəxslər, bir sözlə öz saytını özü hazırlamaq istəyən insanlara çox pul xərcləmədən və proqramistə ehtiyac olmadan kömək etməkdir. </p>
						<p>Hostarex veb vasitəsi ilə siz saytın ümumi görünüşünü – dizaynını özünüz asanlıqla seçə bilərsiniz. Şəkillərinizi əlavə edin, mətnləri istədiyiniz formada yazın və bir sözlə proqramçının gördüyü işi tez və rahat şəkildə özünüz edin. Əgər, çətinlik yaranarsa, bizə müraciət edərək yaranan problemləri tez bir zamanda birlikdə aradan qaldıra bilərik.</p>
						<a class="cta-button" href="sayt-qur">İndi başla!</a>
					</div>
					<div>
						<img class="lazy" src="img/web.svg" alt="hostarex web">
					</div>					
				</div>
			</section>
			<div class="web-svg"></div>
			<section class="hostarex-domain mp-domain">				
				<div>
					<h1>Domen adınızı seçin</h1>
					<p class="subheader">Uğurlu internet layihəsi domen adını qeydiyyatdan keçirməklə başlayır.</p>
				</div>
				<div class="swiper-container">
				    <div class="swiper-wrapper">
				        <div class="swiper-slide">
				        	<div class="domain-one">
					        	<h4>.com</h4>
								<h1> 19.96&#8380; / illik</h1>
								<p>növbəti il yenilənmə qiyməti 19.96&#8380;</p>
							</div>				        	
				        </div>
                        <div class="swiper-slide">
				        	<div class="domain-one">
					        	<h4>.me</h4>
								<h1> 46&#8380; / illik</h1>
								<p>növbəti il yenilənmə qiyməti 46&#8380;</p>
							</div>				        	
				        </div>
                        <div class="swiper-slide">
				        	<div class="domain-one">
					        	<h4>.net</h4>
								<h1> 27&#8380; / illik</h1>
								<p>növbəti il yenilənmə qiyməti 27&#8380;</p>
							</div>				        	
				        </div>
                        <div class="swiper-slide">
				        	<div class="domain-one">
					        	<h4>.info</h4>
								<h1> 31&#8380; / illik</h1>
								<p>növbəti il yenilənmə qiyməti 31&#8380;</p>
							</div>				        	
				        </div>
				    </div>

				    <div class="swiper-button-prev"></div>
				    <div class="swiper-button-next"></div>
				</div>
				<a class="cta-button more-info" href="domain">Ətraflı məlumat</a>
			</section>
			<div class="blog-svg"></div>
			<section class="hostarex-blog">
				<div class="blog-content">
					<h1>Yeni nə var?</h1>
					<div class="all-blogs">
                         {custom template="blog-short" limit="4" category="9" cache="yes"}
					</div>
				</div>
			</section>
			<section class="hostarex-support">
				<div>
					<div class="support-content">
						<p>Hər hansı bir problemlə qarşılaşdınız?</p>
						<h1>24/7 sizə kömək üçün xidmət göstəririk</h1>
						<p>Saytda yaranan texniki problemlərlə bağlı və ya saytı hazırladığınız zaman çətinlik çəkdiyiniz məqam varsa, bizə müraciət edin.</p>
					</div>
				</div>
			</section>
			<section class="hostarex-instagram" id="instagram">
				<div class="insta-content">
					<a class="cta-button more-info" href="https://www.instagram.com/hostarexcom/"><i class="fab fa-instagram"></i> Bizi instagramda izlə</a>
					<div class="posts">
						<div class="post-one">
                        	<img class="lazy" src="img/blog/d.webp" alt="hostarex"/>
                        </div>
                        <div class="post-one">
                        	<img class="lazy" src="img/blog/b.webp" alt="hostarex"/>
                        </div>
                        <div class="post-one">
                        	<img class="lazy" src="img/blog/c.webp" alt="hostarex"/>
                        </div>
					</div>
				</div>
			</section>
            [/aviable]
            {info}{content}
			<footer>
				<div class="footer-content">
					<div class="footer-contact">
						<p class="mail">hello@hostarex.com</p>
						<p class="phon">012 310 22 57</p>
						<ul class="social">
							<li><a href="https://www.facebook.com/hostarexcom"><i class="fab fa-facebook-messenger"></i></a></li>
                            <li><a href="https://www.linkedin.com/company/hostarexcom/"><i class="fab fa-linkedin-in"></i></a></li>
                            <li><a href="https://www.instagram.com/hostarexcom/"><i class="fab fa-instagram"></i></a></li>
                            <li><a href="https://t.me/hostarexcom"><i class="fab fa-telegram-plane"></i></a></li>
						</ul>
						<div class="footer-logo">
							<a href="#"><img src="img/logo-bold.svg" alt="hostarex logo"></a>
						</div>
					</div>	                  
					<div class="footer-menu">
						  <!--<div class="footer-nom">
                            <h4>24/7 dəstək xətti</h4>
                            <h2>*5111</h2>
                            <h5>daxili nömrə: 11</h5>
                        </div>-->
						<ul>
							<li><a href="about">Haqqımızda</a></li>
							<li><a href="tvs">TVS</a></li>
							<li><a href="blog">Bloq</a></li>
							<li><a href="sayt-qur">Sayt qur</a></li>
                           <!--<li><a href="affiliate">Tərəfdaşlıq</a></li>-->
							<li><a href="https://hostarex.com/billing/clientarea.php">Hostarex veb</a></li>
						</ul>
					</div>				
				</div>
			</footer>
		</div>
	</div>
	<script src="menu.js"></script>
    <script src="faq.js"></script>
	<script>
		var mySwiper = new Swiper('.swiper-container', {

		  // Navigation arrows
		  navigation: {
		    nextEl: '.swiper-button-next',
		    prevEl: '.swiper-button-prev',
		  },
		  slidesPerView: 1,
	      spaceBetween: 20,
		  breakpoints: {
	        1024: {
	          slidesPerView: 4,
	          spaceBetween: 20,
	        },
	        768: {
	          slidesPerView: 2,
	          spaceBetween: 40,
	        }
	      }
		})
        
        
	</script>		
    
<!--Start of Tawk.to Script-->
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/5fe34638a8a254155ab5d3ff/1eq7skjrs';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script>
<!--End of Tawk.to Script-->
    
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/tilt.js/1.2.1/tilt.jquery.min.js"></script>
	<script src="https://unpkg.com/tilt.js@1.2.1/dest/tilt.jquery.min.js"></script>
</body>
</html>