<?php

/*
=================================================
 DataLife Engine 11.2 - by SoftNews Media Group
-------------------------------------------------
 http://dle-news.ru/  |  Copyright (c) 2004-2017
=================================================
 DLE.NET.TR - Türkçe Çeviri ve Paketleme
-------------------------------------------------
 http://dle.net.tr  |  Copyright (c) 2014-2017
=================================================
*/
class Minify_DebugDetector {
    public static function shouldDebugRequest($cookie, $get, $requestUri)
    {
        if (isset($get['debug'])) {
            return true;
        }
        if (! empty($cookie['minifyDebug'])) {
            foreach (preg_split('/\\s+/', $cookie['minifyDebug']) as $debugUri) {
                $pattern = '@' . preg_quote($debugUri, '@') . '@i';
                $pattern = str_replace(array('\\*', '\\?'), array('.*', '.'), $pattern);
                if (preg_match($pattern, $requestUri)) {
                    return true;
                }
            }
        }
        return false;
    }
}
