<?php

/*
=================================================
 DataLife Engine 11.2 - by SoftNews Media Group
-------------------------------------------------
 http://dle-news.ru/  |  Copyright (c) 2004-2017
=================================================
 DLE.NET.TR - Türkçe Çeviri ve Paketleme
-------------------------------------------------
 http://dle.net.tr  |  Copyright (c) 2014-2017
=================================================
*/
class HTMLPurifier_ConfigSchema_Builder_ConfigSchema
{

    /**
     * @param HTMLPurifier_ConfigSchema_Interchange $interchange
     * @return HTMLPurifier_ConfigSchema
     */
    public function build($interchange)
    {
        $schema = new HTMLPurifier_ConfigSchema();
        foreach ($interchange->directives as $d) {
            $schema->add(
                $d->id->key,
                $d->default,
                $d->type,
                $d->typeAllowsNull
            );
            if ($d->allowed !== null) {
                $schema->addAllowedValues(
                    $d->id->key,
                    $d->allowed
                );
            }
            foreach ($d->aliases as $alias) {
                $schema->addAlias(
                    $alias->key,
                    $d->id->key
                );
            }
            if ($d->valueAliases !== null) {
                $schema->addValueAliases(
                    $d->id->key,
                    $d->valueAliases
                );
            }
        }
        $schema->postProcess();
        return $schema;
    }
}

// vim: et sw=4 sts=4
